<?php
/*
 * event_editor_popup.php (utf-8)
 * - https://werner-zenk.de
 * vom 30.12.2017 und modifiziert am 12.10.2020
 * bearbeitet von Klaus2 am 11.10.2020
 */


// Pfad zur Datenbank
$datenbank = "db/events.sqt";

// Datenbank-Datei erstellen
if (!file_exists($datenbank)) {
 $db = new PDO('sqlite:' . $datenbank);
 $db->exec("CREATE TABLE events(
  id INTEGER PRIMARY KEY,
  event TEXT,
  datum DATE,
  zeit TIME)");
}
else {

 // Verbindung
 if (!isset($db)) {
  $db = new PDO('sqlite:' . $datenbank);
 }
}

// Verbindung
include "event_funktionen.php";

// Start (Events ausgeben)
if (isset($_GET["start"])) {

 // Events auslesen
 $select = $db->query("SELECT `id`, `event`, `datum`, `zeit`
                                    FROM `events`
                                    ORDER BY `datum`  ASC");
 $events = $select->fetchAll();

 // Events ausgeben
 foreach ($events as $event) {

  // Ist der Event noch aktuell
  $eventAktuell = (date("Y-m-d H:i:s") > $event["datum"]) ?
        '<span class="status_ko" title="der Event ist abgelaufen.">&#10005;</span>' :
        '<span class="status_ok" title="der Event ist aktuell.">&#10003;</span>';

  // Datum und Uhrzeit extrahieren
  sscanf($event["datum"], "%4s-%2s-%2s %2s:%2s", $jahr, $monat, $tag, $zstunde, $zminute);
  sscanf($event["zeit"], "%2s:%2s", $stunde, $minute);

  // Zeilenumbrüche ersetzen (Kontextwechsel zu JavaScript)
  $text = str_replace(["\r\n", "\'"], ["~",], addSlashes($event["event"]));

  // Definitionsliste (HTML) zusammen mit den Daten ausgeben
  echo '<dl><dt>
   <input type="radio" class="event" name="id" id="n' . $event["id"] . '" value="' . $event["id"] . '" ' .

  // JavaScript-Funktionen: einfuegen(), aendern() - Kontextwechsel beachten!
  " onClick='einfuegen(\"" . ($tag - 1) . '", "' . ($monat - 1) . '", "' . $jahr . '", "' . $stunde . '", "' . $minute . '", "' . $zstunde . '", "' . $zminute . '", "' . $text . "\");aendern();'" . '> ' .
   $eventAktuell . ' <label for="n' . $event["id"] . '" class="hilfe" title="Event zum bearbeiten auswählen" class="eventSelected">&nbsp;' . wochentag($tag, $monat, $jahr) .
   ', ' . $tag . ' ' .  monat($monat) . ' ' . $jahr .
  ' &emsp; ' . $stunde . ':' . $minute . ' &#10151; ' . $zstunde . ':' . $zminute . ' Uhr</label></dt>' .
  '<dd>' . strip_tags(mb_substr($event["event"], 0 , 55)) . 
  (strlen($event["event"]) > 55 ? " &hellip;" : "") . '</dd></dl>';
 }

 // Keine weiteren Daten an den Webserver senden
 exit;
}

// Formular wurde gesendet
if ($_SERVER["REQUEST_METHOD"] == "POST") {

  // Passwort überprüfen
 if ($_POST["passwort"] === $passwort) {
		
	$Popupein = './popupein.txt';

	if ((!empty($_POST['popupein'])) && ($_POST['popupein'] == 'ein'))
	{
		if (!file_exists($Popupein))
		{
			touch($Popupein);
		}
	}
	else 
	{
		if (file_exists($Popupein))
		{
			unlink($Popupein);
		}
	}

	// Fallunterscheidung je nach gewählter Option
  switch ($_POST["option"]) :

   // Eintragen
   case 'insert':

   // Datum überprüfen
   if (checkdate($_POST["monat"], $_POST["tag"], $_POST["jahr"])) {

    // Liegt das Datum in der Zukunft
    if (($_POST["jahr"] . '-' . $_POST["monat"] . '-' . $_POST["tag"] . ' ' . $_POST["zstunde"] .':' . $_POST["zminute"]) > date("Y-m-d H:i")) {

     // Event ist nicht leer
     if (!empty($_POST["event"])) {

      // Datum für die DB-Tabelle zusammen setzen (DATETIME-Format)
      $datum = $_POST["jahr"] . '-' . $_POST["monat"] . '-' .
       $_POST["tag"] . ' ' . $_POST["zstunde"] . ':' . $_POST["zminute"] . ':00';

       // Query vorbereiten ...
       $insert = $db->prepare("INSERT INTO `events` (
                                              `event`,
                                              `datum`,
                                              `zeit`)
                                            VALUES (
                                              :event,
                                              :datum,
                                              :zeit)");

      // ... und ausführen
      if ($insert->execute([":event" => $_POST["event"],
                                      ":datum" => $datum,
                                      ":zeit" => $_POST["stunde"] . ':' . $_POST["minute"]])) {
       echo '<span class="status_ok">&#10004;</span> Der Event wurde eingetragen.';
      }
      else {
       echo '<span class="status_ko">&#11613;</span> Fehler beim eintragen in die DB-Tabelle!';
      }
     }
     else {
      echo '<span class="status_ko">&#11613;</span> Der Event fehlt!';
     }
    }
    else {
     echo '<span class="status_ko">&#11613;</span> Das Datum oder die Uhrzeit liegen in der Vergangenheit!';
    }
   }
   else {
    echo '<span class="status_ko">&#11613;</span> Das Datum ist ungültig!';
   }
   break;

   // Ändern
   case 'edit':

   // Event wurde ausgewählt
   if (isset($_POST["id"])) {

    // Datum überprüfen
    if (checkdate($_POST["monat"], $_POST["tag"], $_POST["jahr"])) {

     // Event ist nicht leer
     if (!empty($_POST["event"])) {

      // Datum für die DB-Tabelle zusammen setzen (DATETIME-Format)
      $datum = $_POST["jahr"] . '-' . $_POST["monat"] . '-' .
       $_POST["tag"] . ' ' . $_POST["zstunde"] . ':' . $_POST["zminute"] . ':00';

       // Query vorbereiten ...
       $update = $db->prepare("UPDATE `events`
                                               SET
                                                 `event` = :event,
                                                 `datum` = :datum,
                                                 `zeit` = :zeit
                                               WHERE `id`= :id");

      // ... und ausführen
      if ($update->execute([":event" => $_POST["event"],
                                        ":datum" => $datum,
                                        ":zeit" => $_POST["stunde"] . ':' . $_POST["minute"],
                                        ":id" => $_POST["id"]])) {
       echo '<span class="status_ok">&#10003;</span> Der Event wurde geändert.';
      }
      else {
       echo '<span class="status_ko">&#11613;</span> Fehler beim ändern in der DB-Tabelle!';
      }
     }
     else {
      echo '<span class="status_ko">&#11613;</span> Der Event fehlt!';
     }
    }
    else {
     echo '<span class="status_ko">&#11613;</span> Das Datum ist ungültig!';
    }
   }
   else {
    echo '<span class="status_ko">&#11613;</span> Es wurde kein Event zum ändern ausgewählt!';
   }
   break;

   // Löschen
   case 'delete':

   // Event wurde ausgewählt
   if (isset($_POST["id"])) {

    // Query vorbereiten ...
    $delete = $db->prepare("DELETE FROM `events`
                                           WHERE `id`= :id");

    // ... und ausführen
    if ($delete->execute([":id" => $_POST["id"]])) {
     echo '<span class="status_ok">&#10003;</span> Der Event wurde gelöscht.';
    }
    else {
     echo '<span class="status_ko">&#11613;</span> Fehler beim löschen in der DB-Tabelle!';
    }
   }
   else {
    echo '<span class="status_ko">&#11613;</span> Es wurde kein Event zum löschen ausgewählt!';
   }
   break;

  endswitch;
 }
 else {
  echo '<span class="status_ko">&#11613;</span> Das Passwort ist falsch!';
 }

 // Keine weiteren Daten an den Webserver senden
 exit;
}
?><!DOCTYPE html>
<html lang="de">
 <head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1" />  
  <title>Event - Editor</title>

  <script>
  // Das XMLHttpRequest-Objekt setzen
  var xhr = new XMLHttpRequest();

  // Diese Funktion beim laden der Seite aufrufen
  window.addEventListener("DOMContentLoaded", function () {

  // Dem HTML-Button (id="submit") den Event: "click" zuweisen
  // dieser ruft dann (beim klicken) die Funktion: senden() auf.
  document.getElementById("submit").addEventListener("click", senden);

   // Dem Eingabefeld (id="passwort") den Event: "keydown" zuweisen
   // dieser ruft dann (beim drücken einer Taste "keydown") diese Funktion auf.
  document.getElementById("passwort").addEventListener("keydown", function (event) {

   // Die Eingabetaste wurde gedrückt -> Funktion senden() aufrufen
   if (event.key == "Enter") {
    senden();
   }
  });

  // Dem HTML-Button (id="abbrechen") den Event: "dblclick" zuweisen
  // dieser ruft dann (beim doppelklicken) diese Funktion auf.
  document.getElementById("abbrechen").addEventListener("dblclick", function () {
   document.getElementsByName("Form")[0].reset();
  });

   // Funktion start() aufrufen
   start();
  });

  // Events ausgeben
  function start() {

   // Die Anfrage initialisieren (Methode GET, URL + Querystring)
   xhr.open("GET", document.URL + "?start");

   // Die Anfrage senden
   xhr.send(null);

   // Auf eine Antwort (vom Webserver) warten
   xhr.onreadystatechange = function() {

    // Status überprüfen
    if (xhr.readyState === XMLHttpRequest.DONE &&
        xhr.status == 200) {
     // Antwort ausgeben
     document.getElementById("events").innerHTML = xhr.responseText;
    }
   }
  }

  // Formulardaten senden
  function senden() {

   // Alle Pflichtfelder ausgefüllt
   if (document.getElementsByName("Form")[0].reportValidity()) {

    // Die Daten aus dem Formular holen
    var daten = new FormData(document.getElementsByName("Form")[0]);

    // Die Anfrage initialisieren (Methode POST, Url)
    xhr.open("POST", "event_editor_popup.php");

    // Die Daten senden
    xhr.send(daten);

    // Auf eine Antwort (vom Webserver) warten
    xhr.onreadystatechange = function() {

     // Status überprüfen
     if (xhr.readyState === XMLHttpRequest.DONE &&
         xhr.status == 200) {

      // Antwort ist positiv
      if (xhr.responseText.startsWith('<span class="status_ok">')) {
        
		// Popupstatus merken vor Reset des Formulars
		var popup = document.getElementById("e1").checked;
		// Formular zurücksetzen
       document.getElementsByName("Form")[0].reset();
	   // Popupstatus nach Reset des Formulars wieder setzen
	   document.getElementById("e1").checked = popup;
       // Antwort ausgeben
       document.getElementById("status").innerHTML = xhr.responseText;
       document.getElementById("status").classList.add("toggle");

       // Verzögerungszeit um die Antwort zu löschen
       window.setTimeout(function () {
        document.getElementById("status").innerHTML = "&emsp;";
        document.getElementById("status").classList.remove("toggle");
       }, 2000); // 2000 Millisekunden

       // Funktion start() aufrufen
       start();
      }
      // Antwort ist negativ
      else {

       // Antwort ausgeben
       document.getElementById("status").innerHTML = xhr.responseText;
       document.getElementById("status").classList.add("toggle");

       // Verzögerungszeit um die Antwort zu löschen
       window.setTimeout(function () {
        document.getElementById("status").innerHTML = "&emsp;";
        document.getElementById("status").classList.remove("toggle");
       }, 4000); // 4000 Millisekunden
      }
     }
    }
   }
  }

  // Optionsfeld ändern
  function aendern() {
   document.getElementsByName("Form")[0].option[1].checked = true;
  }

  // Formularfelder mit den übergeben Werten auswählen/befüllen
  function einfuegen(Tag, Monat, Jahr, Stunde, Minute, zStunde, zMinute, Event) {
   var fm = document.getElementsByName("Form")[0];
   fm.tag.selectedIndex = Tag;
   fm.monat.selectedIndex = Monat;
   fm.jahr.value = Jahr;
   fm.stunde.selectedIndex = Stunde;
   fm.minute.selectedIndex = Minute;
   fm.zstunde.selectedIndex = zStunde;
   fm.zminute.selectedIndex = zMinute;
   fm.event.value = Event.replace(new RegExp('~', 'gi'), "\r\n");
  }
  </script>

  <style>
  /* Schrift */
  body, input, select,
  textarea, div#status {
   font-family: Verdana, Arial, Sans-Serif;
   font-size: 0.97rem;
  }

  form {
   width: 560px;
   margin: Auto;
   margin-top: 2rem;
  }

  fieldset {
   background-color: #EEEEEE;
   white-space: Nowrap;
  }

  legend {
   font-size: 1.1rem;
   letter-spacing: 1px;
  }

  p.text-center {
   text-align: Center;
  }

  span#ublock {
   width: 340px;
   display: Inline-Block;
  }

  /* Events */
  div#events {
   width: 530px;
   min-width: 530px;
   max-width: 530px;
   height: 200px;
   min-height: 100px;
   max-height: 550px;
   resize: Vertical;
   overflow: Auto;
   overflow-x: Hidden;
   background-color: #FFFFFF;
   border: Solid 1px #7A7A7A;
   cursor: Default;
  }

  /* Definitionsliste */
  dl {
   margin-top: 0px;
  }

  dt {
   background-color: #F5F5F5;
  }

  dt:hover {
   background-color: #D3E4F1;
  }

  /* Textarea */
  textarea {
   width: 515px;
   min-width: 515px;
   max-width: 515px;
   height: 100px;
   min-height: 100px;
   max-height: 500px;
   resize: Vertical;
   border: Solid 1px #7A7A7A;
   padding: 5px;
  }

  textarea:focus {
   border: Solid 1px #0078D7;
  }

  /* Statuszeile */
  div#status {
   height: 22px;
   padding-left: 10px;
  }

  .toggle {
   background-color: #FFFFFF;
  }

  /* Status */
  span.status_ok {
   color: #35b300;
   font-weight: Bold;
   cursor: help;
  }

  span.status_ko {
   color: #FF0000;
   font-weight: Bold;
   cursor: help;
  }

  /* Label */
  input[type="radio"].event:checked ~ label {
   color: #3582BB;
   box-shadow: Inset 0px 0px 10px 10px #D3E4F1;
  }

  label.eventSelected {
   display: Inline-Block;
   width: 91%;
  }

  input[type="radio"]:checked + label {
   color: #3582BB;
  }

  input[type="radio"]:checked + label#loeschen {
   color: #FF0000;
  }

  input[type="checkbox"]:checked + label#popup {
   color: #00B300;
  }

  /* Passwort */
  input[type=password] {
   width: 160px;
   border: Solid 1px #7A7A7A;
  }

  input[type=password]:focus {
   border: Solid 1px #0078D7;
  }

  input[type="number"] {
  width: 65px;
  }

  .hilfe {
   cursor: help;
  }
  </style>

 </head>
<body>

<form name="Form">

<fieldset>
 <legend>Event - Editor</legend>

<div id="events">
 <noscript>JavaScript erforderlich!</noscript>
</div>

<p class="text-center">
 <?=auswahlTag() . auswahlMonat() . auswahlJahr() . auswahlUhrzeit();?>
</p>

<p>
 <label class="hilfe" title="Bitte füllen Sie dieses Feld aus.">Event: <br>
 <textarea name="event" rows="5" cols="40" required="required"></textarea></label>
</p>

<p class="text-center">
 <input type="radio" name="option" id="u1" value="insert" checked="checked"> <label for="u1" class="hilfe" title="Event eintragen">Eintragen</label> &emsp;
 <input type="radio" name="option" id="u2" value="edit"> <label for="u2" class="hilfe" title="Event ändern&#10;Ein Event muss zum ändern ausgewählt sein!">Ändern</label> &emsp;
 <input type="radio" name="option" id="u3" value="delete"> <label for="u3" id="loeschen" class="hilfe" title="Event löschen&#10;Ein Event muss zum löschen ausgewählt sein!">Löschen</label>
</p>
<p class="text-center">
  <input type="checkbox" name="popupein" id="e1" value="ein" <?php echo (file_exists('./popupein.txt') ? 'checked' : '') ?>> <label for="e1" id="popup" class="hilfe" title="Popup einschalten">Das Popup einschalten</label>
</p>


<div id="status">&emsp;</div>

<p class="text-center">
 <input type="button" value="Abbrechen" id="abbrechen" class="hilfe" title="Das Formular zurücksetzen&#10;Bitte doppelt klicken!">&emsp; 
 <label class="hilfe" title="Bitte füllen Sie dieses Feld aus.">Passwort: <input type="password" name="passwort" id="passwort" required="required"></label>&emsp; 
 <input type="button" value="Ausführen" id="submit" class="hilfe" title="Das Formular senden">
</p>

</fieldset>
</form>

</body>
</html>