<?php
/*
 * mailscript.php versenden über SMTP
 * Version vom 31.10.2025
 * Erfolgreich getestet mit: PHPMailer Version: 7.0.0
 *
 * Erweiterungen:
 * - Dynamisches Einsammeln ALLER Formularfelder (egal wie sie heißen)
 * - Automatischer Mailtext-Aufbau per Schleife
 * - Optionale Reply-To-Setzung anhand gefundener E-Mail im Formular
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require "PHPMailer-master/src/Exception.php";
require "PHPMailer-master/src/PHPMailer.php";
require "PHPMailer-master/src/SMTP.php";

// NEU: Session starten (nur falls Fallback mit Session-Captcha genutzt wird)
session_start();

// Danke- und Fehlerseiten
$dankeSeite  = "danke.html";  // wird nach erfolgreichem Versand aufgerufen
$fehlerSeite = "fehler.html"; // wird bei Fehler aufgerufen

// Fester Betreff (da das Formular selbst keinen Betreff liefert)
$betreffEmail = "Kontaktformular-Dynamisch";

// Wurden POST-Daten gesendet?
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // NEU: Honeypot-Prüfung – wenn das versteckte Feld gefüllt ist, brechen wir ab
    if (!empty($_POST['website'] ?? '')) {
        header("Location: " . $fehlerSeite);
        exit;
    }

    // NEU: Captcha-Prüfung für JS-Variante
    //      Der Client sendet entweder:
    //      - 'captcha_sum'  (bevorzugt) ODER
    //      - 'captcha_op1' + 'captcha_op2'
    //      Falls beides nicht vorhanden, wird – sofern gesetzt – auf die Session-Lösung zurückgegriffen.
    $antwort      = isset($_POST['captcha_answer']) ? (int)$_POST['captcha_answer'] : null;
    $sumPost      = isset($_POST['captcha_sum'])    ? (int)$_POST['captcha_sum']    : null;
    $op1Post      = isset($_POST['captcha_op1'])    ? (int)$_POST['captcha_op1']    : null;
    $op2Post      = isset($_POST['captcha_op2'])    ? (int)$_POST['captcha_op2']    : null;

    // NEU: Server-seitige Vergleichsbasis bestimmen (Reihenfolge: sum -> op1+op2 -> Session)
    $serverSum = null;
    if ($sumPost !== null) {
        $serverSum = $sumPost;
    } elseif ($op1Post !== null && $op2Post !== null) {
        $serverSum = $op1Post + $op2Post;
    } elseif (isset($_SESSION['captcha_sum'])) {
        $serverSum = (int)$_SESSION['captcha_sum'];
    }

    // NEU: Validierung – bei fehlender Basis ODER falschem Ergebnis: Abbruch
    if ($antwort === null || $serverSum === null || $antwort !== $serverSum) {
        header("Location: " . $fehlerSeite);
        exit;
    }

    // NEU: Fallback-Session aufräumen (ohne Nebenwirkung, falls nicht gesetzt)
    unset($_SESSION['captcha_sum']);

    // 1) Zeitzone + Meta-Infos
    date_default_timezone_set("Europe/Berlin");
    $datum = date("d.m.Y H:i");        // z. B. "27.10.2025 15:42"
    $ipAdr = $_SERVER["REMOTE_ADDR"];  // IP des Absenders

    // 2) Formularwerte vorbereiten / säubern
    //    Wir erzeugen ein neues Array $bereinigt, in dem alle Felder aus $_POST
    //    sauber escaped sind (HTML-Sonderzeichen maskiert).
    $bereinigt = [];

    foreach ($_POST as $feldName => $wert) {

        // NEU: Interne Felder (Spamschutz) NICHT in die Mail aufnehmen
        $interneFelder = [
            'website',         // Honeypot
            'captcha_answer',  // Nutzer-Eingabe zur Aufgabe
            'captcha_sum',     // vom JS gesetzte Summe (oder)
            'captcha_op1',     // vom JS gesetzter Operand 1
            'captcha_op2'      // vom JS gesetzter Operand 2
        ];

        // NEU: Diese Felder überspringen
        if (in_array($feldName, $interneFelder, true)) {
            continue;
        }

        // 2a) Falls das Feld selbst ein Array ist (z. B. Checkbox-Gruppen mit []),
        //     machen wir daraus eine komma-separierte Liste.
        if (is_array($wert)) {
            $wert = implode(", ", $wert);
        }

        // 2b) Whitespace an den Rändern entfernen
        $wert = trim($wert);

        // 2c) In Mailtext nur entschärfte Inhalte einfügen (XSS-/HTML-Schutz)
        //     ENT_QUOTES: wandelt auch ' und " um
        //     UTF-8 als Charset
        $wert = htmlspecialchars($wert, ENT_QUOTES, 'UTF-8');

        // 2d) Feldname wie gesendet übernehmen (darf Groß/Klein/Umlaute/Binde-/Unterstrich haben)
        $bereinigt[$feldName] = $wert;
    }

    // 3) Schönen Mail-Body zusammenbauen
    //    Wir schreiben zuerst Meta-Infos, dann alle Felder dynamisch.
    $inhaltEmail  = "Gesendet am: $datum Uhr\n";
    $inhaltEmail .= "IP-Adresse: $ipAdr\n\n";
    $inhaltEmail .= "Formularinhalt:\n";

    foreach ($bereinigt as $feldName => $wert) {
        // Jeder Eintrag eine eigene Zeile:
        // Beispiel: "E-Mail: max@test.de"
        $inhaltEmail .= $feldName . ": " . $wert . "\n";
    }

    // Optional am Ende noch eine Leerzeile
    $inhaltEmail .= "\n";

    // 4) Versuch, eine Absender-Email aus den Formulardaten zu erkennen,
    //    damit wir später Reply-To setzen können.
    //
    //    Hintergrund:
    //    Unterschiedliche Formulare benutzen unterschiedliche Feldnamen:
    //    "email", "Email", "E-Mail", "mail", "kontakt_mail", ...
    //
    //    Wir probieren mehrere gängige Varianten durch.
    $absenderEmail = '';
    $absenderName  = '';

    // Diese Feldnamen gelten als "könnte die E-Mail-Adresse des Besuchers sein"
    $moeglicheEmailFelder = [
        'email', 'Email', 'EMAIL', 'e-mail', 'E-Mail', 'E-mail', 'mail', 'Mail', 'kontakt', 'Kontakt', 'kontakt_mail', 'kontaktMail'
    ];

    foreach ($moeglicheEmailFelder as $feld) {
        // Wir vergleichen case-insensitive:
        // Das bedeutet: Falls das Formular z. B. "E-Mail" sendet,
        // und hier "e-mail" steht, wird es trotzdem erkannt.
        foreach ($bereinigt as $name => $wert) {
            if (strcasecmp($name, $feld) === 0) { // strcasecmp = vergleicht ohne Groß/Kleinschreibung
                // checken ob das Feld wie eine echte E-Mail aussieht
                $valid = filter_var($wert, FILTER_VALIDATE_EMAIL);
                if ($valid !== false) {
                    $absenderEmail = $valid;
                    break 2; // wir haben eine brauchbare Adresse gefunden -> beide Schleifen verlassen
                }
            }
        }
    }

    // Versuch für einen Absender-Namen (ist optional, aber schön)
    // Wir suchen z. B. nach Feldern wie "Name", "Vorname", "Nachricht" ignorieren wir natürlich.
    $moeglicheNamenFelder = [
        'name', 'Name', 'fullname', 'Fullname', 'Vorname', 'Kontaktperson'
    ];

    foreach ($moeglicheNamenFelder as $feld) {
        foreach ($bereinigt as $name => $wert) {
            if (strcasecmp($name, $feld) === 0 && $wert !== '') {
                $absenderName = $wert;
                break 2;
            }
        }
    }

    // 5) PHPMailer vorbereiten
    $mail = new PHPMailer();
    $mail->CharSet = "UTF-8";

    // SMTP Einstellungen
    $mail->isSMTP();
    $mail->Host       = "smtp.ionos.de";                // SMTP-Server - hier beispielhaft die Adresse vom IONOS Server
    $mail->SMTPAuth   = true;                           // SMTP-Authentifizierung aktivieren
    $mail->Username   = "Absender@DeineDomain.de";      // SMTP-Benutzername - meist Deine E-Mail Adresse
    $mail->Password   = "**********";                   // SMTP-Passwort

    // --- Variante 1: Port 465 mit SMTPS (implizite TLS-Verschlüsselung) ---
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;    // Verschlüsselung: SMTPS (TLS ab Verbindungsbeginn)
    $mail->Port       = 465;                            // Port 465 - klassische SSL/TLS-Verbindung

    // --- Alternative Variante 2: Port 587 mit STARTTLS (explizite TLS-Aushandlung) - wenn diese verwendet wird muss Variante 1 // deaktiviert werden ---
    // $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Verschlüsselung: STARTTLS (TLS wird nach Verbindungsaufbau aktiviert)
    // $mail->Port       = 587;                            // Port 587 - alternative, oft in offenen Netzwerken verwendete Verbindung

    // Absender (Diese E-Mail muss beim Provider erlaubt und hinterlegt sein)
    $mail->setFrom("Absender@DeineDomain.de", "Absender-Name");

    // Empfänger (Du selbst)
    $mail->addAddress("Empfänger@DeineDomain.de", "Empfänger-Name");

    // OPTIONAL: Antwort-an (Reply-To) setzen,
    // damit du direkt dem Besucher antworten kannst,
    // aber nur wenn eine valide Adresse gefunden wurde.
    if (!empty($absenderEmail)) {
        $mail->addReplyTo($absenderEmail, $absenderName);
    }

    // Betreff & Body setzen
    $mail->Subject = $betreffEmail;
    $mail->Body    = $inhaltEmail;

    // 6) Senden & Weiterleitung
    if ($mail->send()) {
        header("Location: " . $dankeSeite);
        exit;
    } else {
        header("Location: " . $fehlerSeite);
        exit;
    }
}
?>
